texture Tex;
float2 Center   = {0.5, 0.5};
float BlurWidth = -0.1;
       
sampler2D g_samSrcColor =
sampler_state
{
    Texture = <Tex>;
    AddressU = Clamp;
    AddressV = Clamp;
    MinFilter = Point;
    MagFilter = Point;
    MipFilter = Point;
};
 
struct VS_OUTPUT
{
    float4 Pos      : POSITION;
    float2 TexCoord : TEXCOORD0;
};

VS_OUTPUT vs_main(in float4 pos      : POSITION,
                     in float2 texCoord : TEXCOORD)
{
    VS_OUTPUT Out;
   
    Out.Pos      = pos;
    Out.TexCoord = texCoord;
   
    return Out;
}

float4 ps_main(float2 TexCoord : TEXCOORD0) : COLOR0
{

    float BlurStart = 1.0;
 
    float samples   = 28;// 28 = MAX 

    float4 Color = 0;
   
    for(int i = 0; i < samples; i++)
    {
       float scale = BlurStart + BlurWidth * (i / (samples - 1));
       Color      += tex2D(g_samSrcColor, (TexCoord - Center) * scale + Center );
    }
    Color /= samples;

    return Color;
}


//Technique Calls
technique PostProcess 
{ 
   pass Pass_0 
   { 
      VertexShader = compile vs_1_1 vs_main(); 
      PixelShader = compile ps_2_0 ps_main(); 
   } 
} 
